/*
 * Created on Aug 19, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package DataClasses;
/**
 * @author student
 *
 * This class is being used for holding the user information.
 * 
 */
public class User_Data {
	private String firstName;
	private String lastName;
	private String organisation;
	private String password;
	private String verifier;
	private String userName;
	private String type;
	private int ncbId;
	private String preBillingAmount;
	private double account;
	private StockOwnership_Data[] stocksOwned;
	private Stock_Data[] stocksInterested;
	/**
	 * This is the constructor for User_Data.java
	 */
	public User_Data(
		String type,
		String first,
		String last,
		String org,
		String un,
		String pwd,
		String pwd2,
		String pre,
		String account,
		Stock_Data[] interests) {
		this.type = type;
		this.firstName = first;
		this.lastName = last;
		this.organisation = org;
		this.userName = un;
		this.password = pwd;
		this.verifier = pwd2;
		this.preBillingAmount = pre;
		try {
			this.account = Double.parseDouble(account);
		} catch (Exception e) {
		}

		this.stocksInterested = interests;
	}

	/**
	 * This is the constructor for User_Data.java
	 */
	public User_Data() {
	}

	/**
	 * Method: setFirstName
	 * This method is being used for setting the first name.
	 * @param fName The first name of the user.
	 * @return void
	 */
	public void setFirstName(String fName) {
		this.firstName = fName;
	}
	/**
	 * This method is being used for getting the first name.
	 * @return String The first name of the user.
	 */
	public String getFirstName() {
		return this.firstName;
	}
	/**
	 * This method is being used for setting the last name of the user.
	 * @param lName The last name of the user
	 * @return void
	 */
	public void setLastName(String lName) {
		this.lastName = lName;
	}
	/**
	 * This method is being used for getting the last name of the user.
	 * @return String The last name of the user.
	 */
	public String getLastName() {
		return this.lastName;
	}
	/**
	 * This method is being used for setting the user's password.
	 * @param pwd User password.
	 * @return void
	 */
	public void setPassword(String pwd) {
		this.password = pwd;
	}
	/**
	 * This method is being used for getting the password.
	 * @return String User password.
	 */
	public String getPassword() {
		return this.password;
	}
	/**
	 * This method is being used for setting the user name.
	 * @param uName The user name
	 * @return void
	 */
	public void setUserName(String uName) {
		this.userName = uName;
	}
	/**
	 * This method is being used for getting the user name.
	 * @return String User name.
	 */
	public String getUserName() {
		return this.userName;
	}
	/**
	 * This method is being used for getting the pre-billing amount for the
	 * user.
	 * @param pre The pre-billing amount.
	 * @return void
	 */
	public void setPreBillingAmount(String pre) {
		this.preBillingAmount = pre;
	}
	/**
	 * This method is being used for getting the pre-billing amount.
	 * @return String The pre-billing amount for the user.
	 */
	public String getPreBillingAmount() {
		return this.preBillingAmount;
	}

	/**
	 * This method is being used for setting the ncb Id of the user.
	 * @param ncbid The ncb Id
	 * @return void
	 */
	public void setNcbId(int ncbid) {
		this.ncbId = ncbid;
	}
	/**
	 * This method is being used for getting the ncb Id of the user.
	 * @return int Ncb Id.
	 */
	public int getNcbId() {
		return this.ncbId;
	}
	/**
	 * This method is being used for setting the verifier for the user.
	 * @param ver Verifier for the password.
	 * @return void
	 */
	public void setVerifier(String ver) {
		this.verifier = ver;
	}
	/**
	 * This method is being used for getting the verifier for the password.
	 * @return String The verifier for the user password.
	 */
	public String getVerifier() {
		return this.verifier;
	}

	/**
	 * This method is being used for setting the type of user - Person 
	 * or Organisation.
	 * @param t Type of user.
	 * @return void
	 */
	public void setType(String t) {
		this.type = t;
	}
	/**
	 * This method is being used for getting the type of user - Person
	 * or Organisation.
	 * @return String Type of user.
	 */
	public String getType() {
		return this.type;
	}
	/**
	 * This method is being used for setting the organisation name.
	 * @param o Organisation name
	 * @return void
	 */
	public void setOrganisation(String o) {
		this.organisation = o;
	}
	/**
	 * This method is being used for getting the organisation name.
	 * @return String The organisation name.
	 */
	public String getOrganisation() {
		return this.organisation;
	}

	/**
	 * This method is being used for setting user's account.
	 * @param acc Account of user.
	 * @return void
	 */
	public void setAccount(double acc) {
		this.account = acc;
	}
	/**
	 * This method is being used for getting user's account.
	 * @return double The user account.
	 */
	public double getAccount() {
		return this.account;
	}
	/**
	 * This method is being used for setting stocks owned for the user.
	 * @param stocks The owned stocks
	 * @return void
	 */
	public void setStocksOwned(StockOwnership_Data[] stocks) {
		this.stocksOwned = stocks;
	}
	/**
	 * This method is being used for getting the owned stocks for the user.
	 * @return StockOwnership_Data[]
	 */
	public StockOwnership_Data[] getStocksOwned() {
		return this.stocksOwned;
	}
	/**
	 * This method is being used for getting the interested stocks for the user.
	 * @return Stock_Data[] The stocks user is interested in.
	 */
	public Stock_Data[] getStocksInterested() {
		return this.stocksInterested;
	}
	/**
	 * This method is being used for setting the interested stocks for the user.
	 * @param stocksI The stocks user is interested in.
	 * @return void
	 */
	public void setStocksInterested(Stock_Data[] stocksI) {
		this.stocksInterested = stocksI;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		String str;
		if(this.type.equals("Person"))
			str = this.firstName+" "+this.lastName;
		else
			str = this.organisation;
		return str;
	}
}
